﻿#include  "StdAfx.h"

#include  <atlframe.h>
#include  <atlctrls.h>
#include  <atldlgs.h>

#include  "Resource.h"

#include  "Main.hpp"
#include  "MainDialog.hpp"
#include  "ConfigDialog.hpp"
#include  "LogDialog.hpp"
#include  "CommandProcessor.hpp"
// OnIdle が繰り返し呼ばれるように変更した実装。今は利用していない。利用するなら Run 関数内の CMessageLoop を CCustomizedMessageLoop に置き換える。
//#include  "MessageLoop.hpp"

#include  <boost/lambda/lambda.hpp>
#include  <algorithm>
#include  <szCodecManager.hpp>
#include  <szPath.hpp>

const u32 THREAD_SYNC_TIMEOUT = 10000;

CAppModule theModule;
HWND hMainWnd;

int Run(const szstring &cmdline, int nCmdShow = SW_SHOWDEFAULT)
{
  if (cmdline.empty())
  {
    // コマンドがないので設定ダイアログを表示して終了
    //CConfigDialog configDialog;
    //configDialog.DoModal();

    // メッセージループに入る前なので 0 を返す決まり。
    return 0;
  }

	CMessageLoop theLoop;
	theModule.AddMessageLoop(&theLoop);

	CMainDialog dlgMain;

	if(dlgMain.Create(NULL) == NULL)
	{
    MessageBox(0, SZT("Main dialog creation failed."), SZT("Error"), MB_OK | MB_ICONSTOP);
		return 0;
	}

  hMainWnd = dlgMain.m_hWnd;

  // ワーカースレッドでコマンドのパース、前処理（全体の処理サイズの推定とか）、圧縮解凍処理、後処理という順番で処理する。
  // このようにすることで、巨大ファイルの列挙や、大量のファイルを圧縮する前処理の最中にも進行状況が表示されるので、それをキャンセルすることができる。
  CommandProcessor processor(cmdline, &dlgMain);

	dlgMain.ShowWindow(nCmdShow);

	int nRet = theLoop.Run();

	theModule.RemoveMessageLoop();

  if (!processor.GetState().GetDoneEvent().Wait(THREAD_SYNC_TIMEOUT))
    MessageBox(0, SZT("Thread terminated abnormally."), SZT("Error"), MB_OK | MB_ICONSTOP);

  // CommandProcessor にエラーや警告のログを保存しておき、表示するべきものがあればモーダルでログを表示。
  const std::vector<szstring> &log = processor.GetState().GetLog();
  if (!log.empty())
  {
    using namespace boost::lambda;

    szstring logText;
    std::for_each(log.begin(), log.end(), logText += _1 + SZL("\r\n"));

    CLogDialog logDialog(logText);
    logDialog.DoModal();
  }

	return nRet;
}

int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/, LPTSTR lpstrCmdLine, int nCmdShow)
{
  using namespace szpp;

  int nRet = 0;

  OnClientStartup(hInstance);

  // ローカライズファイル設定
  SetCurrentTextCatalogPath(ChangeFileName(GetClientModuleFileName(), SZL("Languages\\ja.lng")));

  try
  {
    HRESULT hRes = ::CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    ATLASSERT(SUCCEEDED(hRes));

    // this resolves ATL window thunking problem when Microsoft Layer for Unicode (MSLU) is used
    ::DefWindowProc(NULL, 0, 0, 0L);

    AtlInitCommonControls(ICC_TREEVIEW_CLASSES | ICC_PROGRESS_CLASS);

    hRes = theModule.Init(NULL, hInstance);
    ATLASSERT(SUCCEEDED(hRes));

    nRet = Run(0 == lpstrCmdLine ? SZL_EMPTY : szstring(lpstrCmdLine), nCmdShow);

    theModule.Term();
    ::CoUninitialize();
  }
  // 基本的にここで補足される例外は対処のしようがないので、メッセージを表示して終了。
  catch (...)
  {
    MessageBox(0, SZT("Unknown error occurred."), SZT("Error"), MB_OK | MB_ICONERROR);
  }

  OnClientShutdown();

  return nRet;
}
